*******************************************************************************
*                         680xx Grundprogramm symbol                          *
*                         (C) 1989 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                          Symboltabellenverwaltung                           *
*******************************************************************************


* Symboltabellenverwaltung
* Es knnen bis 64 Kbyte verwaltet werden
* Sie mu auf einer Wortgrenze beginnen
* a1 ist der globale Zeiger auf den Start der Tabelle
*
* Record
*  symtab :
*         kleiner.w   : Zeiger auf Record der kleiner ist
*         groesser.w  : Zeiger auf Record der grer ist
*         datenwert.l : Daten
*         attribut.w  : Attribut des Datenwertes
*         name 64 Bit : Name in ASCII mit 8 Zeichen mit Leerzeichen am Ende,
*                       wenn weniger als 8 Zeichen
* groesser=kleiner = 0 dann NIL

kleiner equ 0
groesser equ 2
datenwert equ 4
attribut equ 8
name equ 10

symlen equ 18

namecheck:                      * berprfung ob Name
 cmp.b #'0',d0
 bcs carset                   * Nein
 cmp.b #'9'+1,d0
 bcs carres                   * Ja
bucheck:                        * berprfung ob Buchstabe
 tst.b d0                       * Sonderzeichen auch testen
 bmi.s bucheck1
 cmp.b #'_',d0
 beq carres                   * Ja
 cmp.b #'A',d0
 bcs carset                   * Nein
 cmp.b #'Z'+1,d0
 bcs carres                   * Ja
 cmp.b #'a',d0
 bcs carset                   * Nein
 cmp.b #'z'+1,d0
 bcc carset                   * Nein
 add.b #'A'-'a',d0              * Ja, und gleich in Grobuchstaben gewandelt
bra carres
bucheck1:                       * Auch Sonderzeichen
 cmp.b #'',d0
 beq carres                   *  ist Extracode
 movem.l d1/a0,-(a7)
 lea ztab0(pc),a0
 moveq #anztab-2-1-1,d1         *  ist schon getestet, deshalb noch -1
bucheck2:
 cmp.b (a0)+,d0                 * Vergleich
 beq.s bucheck3                 * OK, gefunden
dbra d1,bucheck2
 movem.l (a7)+,d1/a0
bra carset                    * Fehler, nicht dabei
bucheck3:
 and.b #$df,d0                  * OK, gefunden und in Grobuchstaben gewandelt
 movem.l (a7)+,d1/a0
bra carres                    * OK

setigname:                      * Wie setupname, Leerzeichen werden ignoriert
 bsr igbn

setupname:                      * Name in Register d2,d3
                                * Aufbereiten von a0 an
                                * a0 zeigt auf das Ende des Namens
                                * Carry, wenn Fehler kein gltiger Namenswert
 move.b (a0),d0                 * A..Z erlaubt an erster Stelle
 bsr.s bucheck
 bcs carset                   * Nicht OK
 lea nametab+8(a5),a2           * Zwischenspeicher
 move.l #'    ',-(a2)
 move.l #'    ',-(a2)           * gelscht
 moveq #8-1,d1                  * Maximal 8 Zeichen
setu1:
 move.b d0,(a2)+                * Zeichen ablegen
 addq.l #1,a0                   * Neues Zeichen
 move.b (a0),d0
 bsr namecheck                  * Prfen
 bcs.s setu3                    * Ende Name
dbra d1,setu1                   * Bis Maximal erreicht
setu2:
 addq.l #1,a0                   * Weiter, da OK
 move.b (a0),d0                 * Weiter abfragen
 bsr namecheck
 bcc.s setu2                    * Bis Ende erreicht
setu3:                          * Fertig a0 zeigt auf nchstes Zeichen
 move.l nametab(a5),d2
 move.l nametab+4(a5),d3
bra carres                      * Ohne Carry

getval:                         * Holt Wert aus der Symboltabelle
 lea symtab(a5),a1              * a0 = Name start
                                * Nachher d0.l = Wert   d1.w = Attribut
                                * Carry wenn Fehler
                                * d2 = Kennung
                                * 0 = gefunden 1 = Wenn kleiner Teil nil
                                * 2 = wenn groesser Teil nil
                                * a3 Pointer auf Record

sucheeintrag:                   * Ergebnis d2.l
                                * Hauptprogramm Basis und erster Suchteil
                                * a0 zeigt auf fraglichen Text
                                * a1 zeigt auf Symboltabellenstart
                                * Basis fest
                                * Carry wenn Fehler
                                * d2 = 1 nicht gefunden / Name kleiner
                                * d2 = 2 nicht gefunden / Name groesser
                                * Sonst d0.l = Datenwert  d1.w = Attribut
                                * a3 zeigt auf Record nach der Ausfhrung
 bsr.s setupname                * Carry dann Fehler
 bcs carset                     * Stoppen, Name ungltig
suchein:
 moveq #0,d0
suche:                          * Namen nur einmal festlegen
 lea 0(a1,d0.l),a3
 cmp.l name(a3),d2
 bmi.s suchklei                 * Kleiner Teil suchen
 bhi.s suchgroe                 * Groesser
 cmp.l name+4(a3),d3
 bmi.s suchklei
 bhi.s suchgroe                 * Nun mu gleich sein
 move.l datenwert(a3),d0        * Langwort
 move attribut(a3),d1           * Nur Wort
 moveq #0,d2
bra carres                      * OK Symbol in Ordnung

suchklei:
 move (a3),d0                   * Eigentlich kleiner(a3) aber kleiner=0
 bne.s suche                    * Weiter suchen
 moveq #1,d2
bra carres                      * Nicht gefunden

suchgroe:
 move groesser(a3),d0
 bne.s suche                    * Weiter suchen
 moveq #2,d2                    * Nicht gefunden
bra carres

setval:                         * Setzt Parameter neu wie getval
 lea symtab(a5),a1              * Name noch nicht da

ueberschreibe:                  * Eintragen von Datenwerten wenn ein Name schon
 movem.l d0/d1,-(a7)            * da ist a0=Name a1=Symboltabelle d0.l=Datenwert
 bsr.s sucheeintrag             * d1.w=Attribut
 movem.l (a7)+,d0/d1
 bcs carset                     * Fehler, da Name falsch
 tst d2                         * =0 dann gefunden
 bne carset                     * Sonst Eintrag nicht mglich
 move.l d0,datenwert(a3)        * Langwort
 move d1,attribut(a3)           * Wort
bra carres

                                * Achtung Rev 6.0 gendert
newval:                         * trgt Symbol neu ein Paramter wie setval
 lea symtab(a5),a1              * allerdings mu Name in d2/d3 vorhanden sein

eintrage:                       * Rev 6.0 a3 wird zestrt
                                * Eintragen eines Namens wenn er nicht existiert
                                * a0 zeigt auf Namen a1 auf Symboltabelle
                                * d3 gibt freien Platz an wird erneuert
 movem.l d0/d1,-(a7)
 bsr.s suchein
 movem.l (a7)+,d0/d1
 tst d2                         * =0 dann war schon da
 beq carset
eint0:
 cmp #1,d2                      * Kleiner
 bne.s eint1
 move symnext(a5),d2            * Langwort gltig, da d2.l = 1
 move d2,(a3)                   * Eigentlich kleiner(a3) aber kleiner=0
 bra.s eint2                    * OK, abgespeichert
eint1:
 cmp #2,d2
 bne carset                     * Fatal Fehler
 move symnext(a5),d2            * Langwort gltig, da d2.l = 2
 move d2,groesser(a3)           * Zeiger auf Eintrag
eint2:
 lea 0(a1,d2.l),a3              * Berechnung Adresse absolut bis 64 Kilobyte
 clr.l (a3)+                    * Schnellere Adressierung
 move.l d0,(a3)+
 move d1,(a3)+                  * a3 zerstrt aber schneller
 move.l nametab(a5),(a3)+
 move.l nametab+4(a5),(a3)+
 add #symlen,symnext(a5)        * Neuer Zeiger auf Ende Symboltabelle
bra carres                      * OK alles abgespeichert

symloesche:                     * Symboltabelle lschen
 clr symnext(a5)
 lea symtab+18(a5),a0
 clr.l -(a0)
 clr.l -(a0)
 clr.l -(a0)
 clr.l -(a0)
 clr -(a0)
rts

symbolaus:                      * Symboltabelle ausgeben
 movem.l d0-d3/a0-a2/a6,-(a7)
 move.b cotempo(a5),-(a7)       * Geschindigkeit merken
 move #2,passflag(a5)           * Auf jeden Fall ausgeben
 bsr clrscreen                  * Bildschirm vorher lschen
 moveq #'1',d0                  * Scroll-Geschwindigkeit einstellen
 bsr esc8                       * Immer Hardware-Scroll, wenn mglich
 bsr.s prtsymb
 moveq #'0',d0
 bsr esc7                       * Software-Scroll an danach
 move.b (a7)+,cotempo(a5)       * Alte Geschwindigkeit
 bsr finmenue                   * Ende
 movem.l (a7)+,d0-d3/a0-a2/a6
rts

gettrap:                        * Trap-Nummer holen
 move.l d1,-(a7)
 bsr setupname                  * Name in Ordnung bringen
 movem.l (a7)+,d1
 bcs carset                     * Fehler
 lea trapsym(pc),a1             * Dort stehen Adressen
 moveq #0,d0                    * Nummer des Traps
gettr1:
 addq.l #1,d0                   * Nummer erhhen
 tst.l (a1)                     * Null ist Ende Tabelle
 beq carset
 cmp.l (a1)+,d2                 * Name erster Teil
 bne.s gettr2
 cmp.l (a1)+,d3                 * Name zweiter Teil
 bne.s gettr1
 move.l d0,d2                   * Name ist verglichen und OK
 add.l d0,d0                    * d2 ist Trap-Nummer
 add.l d0,d0                    * Adresse holen
 lea traptab-4(pc),a1
 move.l 0(a1,d0.l),d0           * Adresse der Routine
 lea basis(pc),a1
 add.l a1,d0                    * Basis bercksichtigen
bra carres

gettr2:                         * a1 um 4 erhhen fr nchsten Wert
 addq.l #4,a1
bra.s gettr1
prtsymb:                        * Abbruch mit CTRL C
 lea symtab(a5),a1              * Tabelle maximal 64 Kbyte
 movea.l a7,a6                  * Stackmerker bei Abbruch
 moveq #0,d3
prtsymb1:
 tst kleiner(a1,d3.l)           * Hier kleinsten Wert suchen
 beq.s prtsymb2                 * Gefunden
 move d3,-(a7)                  * Weiter suchen
 move kleiner(a1,d3.l),d3       * Rekursiv aufrufen
 bsr.s prtsymb1                 * Hier
 move (a7)+,d3                  * d3 zurck
prtsymb2:
 movem.l d3/a1,-(a7)
 lea ausbuf(a5),a0              * Symbol und Werte ausgeben
 move.l name(a1,d3.l),(a0)+
 move.l name+4(a1,d3.l),(a0)+   * Namen ablegen
 move #'  ',(a0)+
 move.l datenwert(a1,d3.l),d0   * Dann Datenwert
 bsr print8x                    * Hexadezimal
 move #'  ',(a0)+
 move attribut(a1,d3.l),d0      * Attribut auch
 move d0,d1
 bsr print4x                    * Auch hexadezimal
 move.l #'    ',(a0)+
 cmp #6,d1                      * Attribut entschlsseln / Wenn grer als 6
 bmi.s prtsymb3                 * Dann nur Striche ausgeben, da unbekannt
 moveq #6,d1
prtsymb3:
 move.b symatxt(pc,d1),d1       * Anfangswert Text
 lea symatxt(pc,d1),a2          * Adresse Text berechnet
prtsymb4:
 move.b (a2)+,(a0)+             * Text in Buffer bertragen
 bne.s prtsymb4
 lea ausbuf(a5),a0              * Text
 bsr prtco2                     * ausgeben
 bsr crlfe                      * Danach CR LF ausfhren
 movem.l (a7)+,d3/a1
 bsr co2test                    * Abbruch abfragen
 bcs.s prtsymb6
 tst groesser(a1,d3.l)          * Jetzt nchsten Wert suchen
 beq.s prtsymb5
 move d3,-(a7)
 move groesser(a1,d3.l),d3
 bsr prtsymb1                   * Wieder rekursiv
 move (a7)+,d3
prtsymb5:
rts
prtsymb6:
 movea.l a6,a7                  * a6 war Merker Stack fr Abbruch
rts

symatxt:
 dc.b 7,14,19,24,33,39,51       * Byte innerhalb der Tabelle fr Textberechnung
 dc.b 'FEHLER',0
 dc.b 'BYTE',0
 dc.b 'WORT',0
 dc.b 'LANGWORT',0
 dc.b 'GETEA',0
 dc.b 'UNDEFINIERT',0
 dc.b '-----------',0

ds 0



****************** Hilflabels, wenn fr direkte Sprnge zu weit ***************

gr1p5_: bra gr1p5

                                                                                                                                                                                                                                                                                                                        